using UnityEngine;
using System.Collections;

public class s_MainMenu : MonoBehaviour 
{
	public GameObject GOLevelSelect;
	
	//HowTo Stuff
	public GameObject[] howToPlayPages;
	public GameObject buttonForward;
	public GameObject buttonBack;
	public GameObject buttonMute;
	public Texture2D buttonMuteOn;
	public Texture2D buttonMuteOff;
	public GameObject musicTitle;
	//public Texture2D background;
	//public GUISkin myskin;
	//public Rect optionRect = new Rect((Screen.width/2)-100,(Screen.height/2)+100,200,30);
	//public string messageToDisplayOnClick = "About \n Press Esc to go back";
	//private string clicked = "";
	
	string currentAnimationName; //For moving the animation to the end if you click
	
	s_LevelSelect levelSelect = null;
	bool mLoading = false;
	
	float howToPlayPageDepth = 0.0001f;
	Vector3 pagePos;
	int currentHowToPage = 0;
	int previousHowToPage = 0;
	
	void Start()
	{
		//First time thing
		if (PlayerPrefs.GetInt("Stars 0") == 0)
		{
			for (int i = 0; i < Application.levelCount - s_LevelSelect.levelOffset; ++i)
				PlayerPrefs.SetInt("Stars " + i, s_LevelSelect.invalidLevel);
		}
		
		levelSelect = GOLevelSelect.GetComponent<s_LevelSelect>();
		StartCoroutine(CreateHowToPlay());
	}
	
	IEnumerator CreateHowToPlay()
	{
		yield return new WaitForFixedUpdate();
		
		pagePos = new Vector3(10, 0, -5.8f);
		float currentDepth = howToPlayPageDepth;
		
		for (int i = howToPlayPages.Length-1; i >= 0; --i)
		{
			howToPlayPages[i].transform.parent.transform.position = new Vector3(0, currentDepth, -5.8f);
			currentDepth += howToPlayPageDepth;
		}
		
		UpdateSoundButton();
	}
	
	void Update()
	{
		
		if (Input.GetKeyDown(KeyCode.T))
			StartCoroutine(CreateHowToPlay());
		//Gets input: click for osx, windows, and editor. Touch for android and iphone
#if UNITY_EDITOR || UNITY_STANDALONE_WIN || UNITY_STANDALONE_OSX || UNITY_WEBPLAYER
		if (Input.GetMouseButtonDown(0))
#endif
					
#if UNITY_ANDROID && !UNITY_EDITOR || UNITY_IPHONE && !UNITY_EDITOR
		for (int i = 0; i < Input.touchCount; ++i)
            if (Input.GetTouch(i).phase.Equals(TouchPhase.Began))
#endif
						
		{
				
			//Then makes a ray, for touch or click position
#if UNITY_ANDROID && !UNITY_EDITOR || UNITY_IPHONE && !UNITY_EDITOR
 			Ray ray = Camera.main.ScreenPointToRay(Input.GetTouch(i).position);
#endif
				
#if UNITY_EDITOR || UNITY_STANDALONE_WIN || UNITY_STANDALONE_OSX || UNITY_WEBPLAYER
			Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);
#endif
			
			RaycastHit hit;
			
			//Animation Skips
			if (transform.parent.animation.isPlaying)
			{
				transform.parent.animation[currentAnimationName].time = 1;
				return;
			}
				
			if (levelSelect && levelSelect.animation.isPlaying)
			{
				levelSelect.animation[levelSelect.currentAnimationName].time = 1;
				return;
			}
				
			if (howToPlayPages[previousHowToPage].animation.isPlaying)
			{
				howToPlayPages[previousHowToPage].animation[currentAnimationName].time = 1;
				return;
			}
			else if (howToPlayPages[currentHowToPage].animation.isPlaying)
			{
				howToPlayPages[currentHowToPage].animation[currentAnimationName].time = 1;
				return;
			}
				
			//Dont want to click anything if you already picked a level
			if (mLoading)
				return;
				
			//If you click on something
	  		if (Physics.Raycast(ray, out hit, 100.0f))
			{
				//MainMenu//
					
				//To level select
				if (hit.collider.gameObject.name == "ButtonMainLevelSelect")
				{
					s_Buttons button = hit.collider.gameObject.GetComponent<s_Buttons>();
					button.Clicked();
						
					currentAnimationName = "MainMenuCameraUp";
					transform.root.transform.position = transform.parent.transform.position;
					StartCoroutine(LevelSelect());
				}
				//To how to play
				else if (hit.collider.gameObject.name == "ButtonMainHowTo")
				{
					s_Buttons button = hit.collider.gameObject.GetComponent<s_Buttons>();
					button.Clicked();
						
					currentAnimationName = "MainMenuCameraDown";
					transform.root.transform.position = transform.parent.transform.position;
					transform.parent.animation.Play(currentAnimationName);
					UpdateHowToButtons();
				}
				
			
				//LevelSelect//
					
				//LevelSelectButtons
				else if (hit.collider.gameObject.tag == "Button")
				{
					s_LevelSelectButton button = hit.collider.gameObject.GetComponent<s_LevelSelectButton>();
					if (button.Clicked())
						mLoading = true;
				}
				//More levels
				else if (hit.collider.gameObject.name == "ButtonLevelSelectMore")
				{
					s_Buttons button = hit.collider.gameObject.GetComponent<s_Buttons>();
					button.Clicked();
						
					levelSelect.transform.parent.transform.position = levelSelect.transform.position;
					levelSelect.currentAnimationName = "MainMenuCameraLeft";
					levelSelect.animation.Play("MainMenuCameraLeft");
					AudioManager.PlaySound(AudioManager.buttonYes);
					++levelSelect.currentPage;
					levelSelect.UpdateMoveButtons();
				}
				//Back Levels
				else if (hit.collider.gameObject.name == "ButtonLevelSelectBack")
				{
					s_Buttons button = hit.collider.gameObject.GetComponent<s_Buttons>();
					button.Clicked();	
					
					levelSelect.transform.parent.transform.position = levelSelect.transform.position;
					levelSelect.currentAnimationName = "MainMenuCameraRight";
					levelSelect.animation.Play("MainMenuCameraRight");
					AudioManager.PlaySound(AudioManager.buttonYes);
					--levelSelect.currentPage;
					levelSelect.UpdateMoveButtons();
				}
				//To main menu
				else if (hit.collider.gameObject.name == "ButtonLevelSelectMain")
				{
					s_Buttons button = hit.collider.gameObject.GetComponent<s_Buttons>();
					button.Clicked();
						
					currentAnimationName = "MainMenuCameraDown";
					transform.root.transform.position = transform.parent.transform.position;
					StartCoroutine(MainMenu());
				}
					
					
				//HowToPlay//
					
				//More Screens
				else if (hit.collider.gameObject.name == "ButtonHowToMore")
				{
					s_Buttons button = hit.collider.gameObject.GetComponent<s_Buttons>();
					button.Clicked();
						
					currentAnimationName = "HowToPlayForward";
					howToPlayPages[currentHowToPage].transform.parent.transform.position = howToPlayPages[currentHowToPage].transform.position;
					howToPlayPages[currentHowToPage].animation.Play("HowToPlayForward");
					UpdateHowToPage(1);
				}
				//Back Screens
				else if (hit.collider.gameObject.name == "ButtonHowToBack")
				{
					s_Buttons button = hit.collider.gameObject.GetComponent<s_Buttons>();
					button.Clicked();
					
					UpdateHowToPage(-1);
					currentAnimationName = "HowToPlayBack";
					//howToPlayPages[currentHowToPage].transform.parent.transform.position = howToPlayPages[currentHowToPage].transform.position;
					howToPlayPages[currentHowToPage].animation.Play("HowToPlayBack");
				}
				//To main menu
				else if (hit.collider.gameObject.name == "ButtonHowToMain")
				{
					s_Buttons button = hit.collider.gameObject.GetComponent<s_Buttons>();
					button.Clicked();
						
					currentAnimationName = "MainMenuCameraUp";
					transform.root.transform.position = transform.parent.transform.position;
					StartCoroutine(MainMenu());
					ResetHowToPages();
				}
				//Mute button
				else if (hit.collider.gameObject.name == "ButtonMute")
				{
					s_Buttons button = hit.collider.gameObject.GetComponent<s_Buttons>();
					button.Clicked();
						
					AudioManager.mute = !AudioManager.mute;
					UpdateSoundButton();
				}
					
			}
		}
	}
	
	void UpdateSoundButton()
	{	
		if (AudioManager.mute)
		{
			AudioListener.volume = 0;
			buttonMute.renderer.material.mainTexture = buttonMuteOn;
		}
		else
		{
			AudioListener.volume = 0.7f;
			buttonMute.renderer.material.mainTexture = buttonMuteOff;
		}
			
	}
	
	void ResetHowToPages()
	{
		for (int i = 0; i < howToPlayPages.Length; ++i)
		{
			howToPlayPages[i].transform.position = new Vector3(pagePos.x,
																howToPlayPages[i].transform.parent.transform.position.y,
																pagePos.z);
		}
		
		currentHowToPage = 0;
		previousHowToPage = 0;
	}
	
	void UpdateHowToPage(int aAmount)
	{
		previousHowToPage = currentHowToPage;
		currentHowToPage += aAmount;
		
		UpdateHowToButtons();
	}
			
	void UpdateHowToButtons()
	{
		//Sound Button
		if (currentHowToPage == 0)
			ShowButton(buttonMute);
		else
			HideButton(buttonMute);
		//Move Screen Buttons
		if (currentHowToPage < howToPlayPages.Length - 1)
			ShowButton(buttonForward);
		else
			HideButton(buttonForward);
			
		if (currentHowToPage > 0)
			ShowButton(buttonBack);
		else
			HideButton(buttonBack);
	}
	
	void HideButton(GameObject aButton)
	{
		aButton.renderer.enabled = false;
		aButton.collider.enabled = false;
	}
	
	void ShowButton(GameObject aButton)
	{
		aButton.renderer.enabled = true;
		aButton.collider.enabled = true;
	}
	
	IEnumerator LevelSelect()
	{
		AudioManager.PlaySound(AudioManager.buttonYes);
		
		//Gives a delay in the animation first time, to give everything time to load
		if (levelSelect != null)
		{
			transform.parent.animation.Play(currentAnimationName);
			yield return new WaitForSeconds(AudioManager.buttonYes.length / 2);
		}
		else
		{
			yield return new WaitForSeconds(AudioManager.buttonYes.length / 2);
			transform.parent.animation.Play(currentAnimationName);
		}
	}
		
	IEnumerator HowToPlay()
	{
		AudioManager.PlaySound(AudioManager.buttonYes);
		
		transform.parent.animation.Play(currentAnimationName);
		yield return new WaitForSeconds(AudioManager.buttonYes.length / 2);
	}
	
	IEnumerator MainMenu()
	{
		transform.parent.animation.Play(currentAnimationName);
		
		yield return new WaitForSeconds(AudioManager.buttonNo.length);
		
		if (levelSelect)
			levelSelect.UpdateMovementParent();
	}
	
	/*
	void OnGUI()
	{	
		//Play
		if(GUI.Button (new Rect(Screen.width/2 + 50, Screen.height/2, 100, 95), "Play"))
		{
			StartCoroutine(LevelSelect());
		}	
		
		//How To Play
		if(GUI.Button (new Rect(Screen.width/2 - 150, Screen.height/2, 100, 95), "How To Play"))
		{
			StartCoroutine(HowToPlay());
		}
		
		//background
		GUI.DrawTexture (new Rect(0,0,Screen.width, Screen.height),background);
		
		if(clicked == "" || clicked == "Options")
		{
			GUI.skin = myskin;
			
			//Options
			if(GUI.Button (new Rect((Screen.width/2)-100,(Screen.height/2)+100,200,30), "Options"))
			{
				clicked = "Options";
							
			}
			else if (clicked == "Options")
			{
				optionRect = GUI.Window (0,new Rect(Screen.width/2-100, Screen.width/2-30,200,200), optionsFunc, "Options");
				
			}
			
			//Quit
			if(GUI.Button (new Rect((Screen.width/2)-100,(Screen.height/2)+150,200,30), "Quit"))
			{
				Application.Quit();
			}
		}
	}
	*/
	
	//drag window for options
	/*
	void optionsFunc(int windowID)
	{
		GUI.DragWindow (new Rect (0,0,100000,20));
		GUILayout.Box ("Volume");
		
		if(GUILayout.Button ("Back"))
		{
			clicked = "";
		}
		
		
	}
	void update()
	{
		if(clicked == "about" && Input.GetKey (KeyCode.Escape))
		{
			clicked = "";
		}
	}
	*/
}
